//=============================================================================
// AmmoShell.
//=============================================================================
class MSBorderlandsMutator extends DeusExPickup;

var MSBorderlandsSummonMutator Mutator;
var BorderlandsDeathDetector Detector;
var int ItemChance;
var Pawn LastKill;
var DeusExPlayer P;

var int TargetMaxHealth;
var string Target;
var Window TargetBar, TargetWindow;
var ModifiedPersonaTextWindow TargetText;

//var BLFrobDisplayWindow CustomFrob;

var int CurTargetSpacing;

var Travel string CurrentLevel, CurXP, XPNeeded;

Var Travel Bool bNoCustomFrob;
var Travel string LastMapName;

#exec TEXTURE IMPORT FILE="Textures\TargetDisplayTex1.pcx" NAME="TargetDisplayTex1" GROUP="Icons" MIPS=Off FLAGS=2
#exec TEXTURE IMPORT FILE="Textures\TargetHealthTex1.pcx" NAME="TargetHealthTex1" GROUP="Icons" MIPS=Off FLAGS=2

function RandomEncounter(name N, out int i)
{
 local float F;
 
 F = Frand();

 if (n == 'Bandit')
 {
  if (F <= 0.03)
  {
   i = 1;
   return;
  }
  if (F > 0.03)
  {
   i = 0;
   return;
  }
 }

 if (n == 'Bruiser')
 {
  if (F <= 0.09)
  {
   i = 1;
   return;
  }
  if (F > 0.09)
  {
   i = 0;
   return;
  }
 }
}

final function string RightTrim(String A, int B)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Right(s, B);
 
 n = s2;
 
 return n;
}

final function string MidTrim(string A, int B, optional int C)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Mid(s, B, C);
 
 n = s2;
 
 return n;
}

final function string LeftTrim(string A, int B)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Left(s, B);
 
 n = s2;
 
 return n;
}

function ToggleFrobDisplay()
{
 if (bNoCustomFrob)
 {
  bNoCustomFrob = False;
  ReplaceFrobDisplay(FirstPlayer());
  FirstPlayer().PlaySound(sound'Menu_BuySkills');
  return;
 }
 if (!bNoCustomFrob)
 {
  bNoCustomFrob = True;
  RestoreFrobDisplay(FirstPlayer());
  FirstPlayer().PlaySound(sound'Menu_Cancel');
  return;
 }
}

function SetTarget(ScriptedPawn P, int NewMax)
{
 if (P == None) return;
 
 if (TargetWindow == None) SpawnTargetWindow();
 
 Target = String(P);
 TargetMaxHealth = NewMax;
 
 TargetText.SetText(P.UnfamiliarName);
 
 TargetBar.SetSize(  ( float(P.Health) / float(NewMax) ) * 120  , 32);
 //TargetWindow.SetTarget(P);
}

function UpdateTarget(ScriptedPawn P)
{
 if (Target == "")
 {
  TargetBar.SetSize(0, 32);
  TargetText.SetText("");
  return;
 }
 if (TargetWindow == None) return;
 
 TargetText.SetText(P.UnfamiliarName);
 
 TargetBar.SetSize(  ( float(P.Health) / float(TargetMaxHealth) ) * 120  , 32);
}

function HideTargetWindow()
{
 /*
 //Fucking broken on so many levels.
 return;
 
 Target = "";
 
 TargetWindow.SetSize(0,0);
 TargetWindow.Hide();
 TargetWindow.SetBackground(None);
 TargetWindow.Destroy();
 TargetWindow = None;
 
 TargetText.SetSize(0,0);
 TargetText.Hide();
 TargetText.SetBackground(None);
 TargetText.Destroy();
 TargetText = None;
 
 TargetBar.SetSize(0,0);
 TargetBar.Hide();
 TargetBar.SetBackground(None);
 TargetBar.Destroy();
 TargetBar = None;*/
}

function SpawnTargetWindow()
{
/* local DeusExPlayer P;
 local DeusExRootWindow Root;
 local BLTargetWindow2 BLT;
 
 return;
 
 if (TargetWindow != None) return;
 
 CustomFrob.TargetWindow = CustomFrob.NewChild(Class'BLTargetWindow');
 TargetWindow = CustomFrob.TargetWindow;
 
 TargetWindow.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
 
 TargetWindow.SetBackground(Texture'TargetDisplayTex1');
 TargetWindow.SetBackgroundStyle(DSTY_Masked);
 TargetWindow.SetPos(256, 0);
 TargetWindow.SetSize(128, 32);
 
 CustomFrob.TargetText = ModifiedPersonaTextWindow(CustomFrob.NewChild(class'ModifiedPersonaTextWindow'));
 TargetText = CustomFrob.TargetText;
 
 //TargetText = ModifiedPersonaTextWindow(TargetWindow.Text);
 
 TargetText.SetPos(265, 9);
 TargetText.SetSize(128, 32);
 TargetText.SetFont(Font'FontMenuHeaders');
 TargetText.SetText("");
 
 CustomFrob.TargetBar = CustomFrob.NewChild(Class'Window');
 TargetBar = CustomFrob.TargetBar;
 
 //TargetBar = TargetWindow.Bar;
 
 TargetBar.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
 
 TargetBar.SetBackground(Texture'TargetHealthTex1');
 TargetBar.SetBackgroundStyle(DSTY_Masked);
 TargetBar.SetPos(256, 0);
 TargetBar.SetSize(0, 32);*/
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 SetTimer(1, True);
 if (FirstLevel().MapName != "WepCamp") LastMapName = FirstLevel().MapName; 
 //ReplaceShit();
}

function Timer()
{
 AttachToPlayer();
 PrepDeaths();
 PrepMutator();
 ClearCorpses();
 ReplaceFrobDisplay(FirstPlayer());
 ReplaceShit();
 
 //UpdateTarget();
 
 /*if (Target != "") CurTargetSpacing++;
 
 if (CurTargetSpacing > 3 || Target == "")
 {
  HideTargetWindow();
  CurTargetSpacing = 0;
 }*/
}

function TravelPreAccept()
{
 HideTargetWindow();
 
 Super.TravelPreAccept();
}

function DeusExLevelInfo FirstLevelInfo()
{
 local DeusExLevelInfo Inf;
 
 forEach allActors(class'DeusExLevelInfo', Inf)
 {
  return Inf;
 }
}

function DeusExPlayer FirstPlayer()
{
 local DeusExPlayer Play;
 
 forEach allActors(class'DeusExPlayer', Play)
 {
  return Play;
 }
}

function bool IsRedundant(class<Actor> A)
{
 local Actor CurA;
  
 forEach AllActors(A, CurA)
 {
  if (CurA != None) return True;
 }
 
 return false;
}

function ReallignMutator()
{
 local MSBorderlandsSummonMutator A;
 
 forEach AllActors(class'MSBorderlandsSummonMutator', A)
 {
  if (A != None)
  {
   Mutator = A;
   A.Mutator = Self;
  }
 }
}

function PrepMutator()
{
 local MSBorderlandsSummonMutator A;
 
 if (IsRedundant(class'MSBorderlandsSummonMutator'))
 {
  ReallignMutator();
  return;
 }
 
 A = Spawn(class'MSBorderlandsSummonMutator',,,Location + vect(0,0,15));
// A.Feed = Self;
 Mutator = A;
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 SetTimer(1, True);
 //AttachToPlayer();
 //ReplaceShit();
}

function ReplaceFrobDisplay(DeusExPlayer P) //modified to spawn the custom frobdisplay...
{
  		local deusexrootwindow root;
		local frobdisplaywindow poorfrobdisplay;

 		root = DeusExRootWindow(P.rootwindow); //find our root

		if (root == none || root.hud.frobdisplay.IsA('BLFrobDisplayWindow') || bNoCustomFrob) return;

 		if ((root != none) && (!root.hud.frobdisplay.IsA('BLFrobDisplayWindow')))//if we're not the custom type...
 		{
		 poorfrobdisplay = root.hud.frobdisplay;
  		 root.hud.frobDisplay.Hide(); //HIDE the old frobdisplay and tell us what it was...
		 poorfrobdisplay.Player = None; //un-attach us from the player...
		 poorfrobdisplay.Destroy();  //then kill us...
                 root.hud.DescendantRemoved(poorfrobDisplay); //and make us THINK we destroyed it...
 		 root.hud.frobDisplay = BLFrobDisplayWindow(root.hud.NewChild(Class'BLFrobDisplayWindow')); //and spawn a new one of our custom type...
		 root.hud.frobDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full); //this is important I think... 
 		 
		 //CustomFrob = BLFrobDisplayWindow(root.hud.frobDisplay);
		}
}

function RestoreFrobDisplay(DeusExPlayer P)
{
  		local deusexrootwindow root;
		local frobdisplaywindow poorfrobdisplay;

 		root = DeusExRootWindow(P.rootwindow); //find our root

		if (root == none || !root.hud.frobdisplay.IsA('BLFrobDisplayWindow') || !bNoCustomFrob) return;

 		if ((root != none) && (root.hud.frobdisplay.IsA('BLFrobDisplayWindow')))//if we're not the custom type...
 		{
		 poorfrobdisplay = root.hud.frobdisplay;
  		 root.hud.frobDisplay.Hide(); //HIDE the old frobdisplay and tell us what it was...
		 poorfrobdisplay.Player = None; //un-attach us from the player...
		 poorfrobdisplay.Destroy();  //then kill us...
                 root.hud.DescendantRemoved(poorfrobDisplay); //and make us THINK we destroyed it...
 		 root.hud.frobDisplay = FrobDisplayWindow(root.hud.NewChild(Class'FrobDisplayWindow')); //and spawn a new one of our custom type...
		 root.hud.frobDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full); //this is important I think... 
 		 
		 //CustomFrob = BLFrobDisplayWindow(root.hud.frobDisplay);
		}
}

function AttachToPlayer()
{
 local DeusExPlayer P, Guy;
 
 //if (Base.IsA('DeusExPlayer') || P != None) return;
 
 if (CurrentLevel ~= "") CurrentLevel = "1";
 
 forEach AllActors(class'DeusExPlayer', P)
 {
  if (P != None)
  {
   Guy = P;
   break;
  }
 }
 
 if (P.FindInventoryType(class'MSBorderlandsMutator') != None) return;
 
 Guy.ClientMessage("MSBorderlands Mutator Activated.");
 SetBase(Guy);
 GiveTo(Guy);
 SpawnCopy(Guy);
 
 P = Guy;
 
 ReplaceFrobDisplay(P);
}

function PrepDeaths()
{
 local BorderlandsDeathDetector A;
 
 if (IsRedundant(class'BorderlandsDeathDetector')) return;
 
 A = Spawn(class'BorderlandsDeathDetector',,,Location + vect(0,0,10));
 A.Feed = Self;
 Detector = A;
}

function ReplaceShit()
{
 local Containers C;
 local Bandit Bandit;
 local int i;
 local GunChest G;
 local ScriptedPawn S;
 local MidgetPsycho Midget;
 local Psycho Psycho;
 local NanoKey Key;
 local Bruiser Bruiser;
 local ElementalBarrel Barrel;
 local Barrel1 B;
 local ElectronicDevices V;
 local BLWeaponVendor Vendor;
 local string EncounterType;
 local int bEncountered;
 
 local Vector Comp;
 
 forEach AllActors(class'Containers', C)
 {
  if (C != None && C.Contents != None && class<Weapon>(C.Contents) != None)
  {
   G = Spawn(class'GunChest',,,C.Location - (vect(0,0,1) * C.CollisionHeight) + (vect(0,0,1) * class'GunChest'.Default.CollisionHeight), C.Rotation);
   G.WeaponLevel = int(CurrentLevel);
   G.UpdateGunLevels();
   C.Contents = None;
   C.Destroy();
  }
  if (C != None && C.Contents != None && class<Pickup>(C.Contents) != None)
  {
   if (frand() > 0.33) Spawn(class'AmmoChest',,,C.Location - (vect(0,0,1) * C.CollisionHeight) + (vect(0,0,1) * class'GunChest'.Default.CollisionHeight), C.Rotation);
   else G = Spawn(class'GunChest',,,C.Location - (vect(0,0,1) * C.CollisionHeight) + (vect(0,0,1) * class'GunChest'.Default.CollisionHeight), C.Rotation);
   G.WeaponLevel = int(CurrentLevel);
   G.UpdateGunLevels();
   C.Contents = None;
   C.Destroy();
  }
 }
 forEach AllActors(class'Barrel1', B)
 {
   B.SetCollision(False, False, False);
   
   Barrel = Spawn(class'ElementalBarrel',,,B.Location, B.Rotation);
   Barrel.DamageLevel = int(CurrentLevel);
   Barrel.RandomizeElement();
   
   B.bExplosive = False;
   B.Contents = None;
   B.Destroy();
 }
 forEach AllActors(class'ElectronicDevices', V)
 {
  if (V.IsA('VendingMachine') || V.IsA('CigaretteMachine'))
  {
   V.SetCollision(False, False, False);
   
   Vendor = Spawn(class'BLWeaponVendor',,,V.Location, V.Rotation);
   Vendor.VendorLevel = int(CurrentLevel);
   Vendor.RandomizeStock();
   Vendor.MinLeft = 10;
   Vendor.SecLeft = 0;
   Vendor.SetTimer(1, True); //randomize stock every 10 minutes
   
   V.Contents = None;
   V.Destroy();
  }
 }
 




 forEach AllActors(class'ScriptedPawn', S)
 {
  //Comp = Vect(0,0,0);
  
  //if (!S.bInWorld) Comp = vect(0,0,-20000);
  
  if (S.bInWorld)
  {
  if (S.IsA('MJ12Troop') || S.IsA('Cop') || S.IsA('Mj12Commando') || S.IsA('HKMilitary') || S.IsA('Soldier') || S.IsA('Sailor') || S.IsA('Terrorist') || (S.IsA('UNATCOTroop') && S.bInWorld && (FirstLevelInfo().MissionNumber > 4 || FirstPlayer().FlagBase.GetBool('TalkedToPaulAfterMessage_Played') )) || (S.IsA('RiotCop') && FirstLevelInfo().MissionNumber > 3))
  {
   S.SetCollisionSize(0,0);
   S.SetCollision(False, False, False);

   RandomEncounter('Bandit', bEncountered);

   if (bEncountered < 1)
   {
    if (Frand() < 0.8 && !S.IsA('MJ12Commando')) Bandit = Spawn(class'Bandit',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);
    if (Bandit == None || S.IsA('MJ12Commando')) Bandit = Spawn(class'BadassBandit',S.Owner,S.Tag,S.Location + vect(0,0,20), S.Rotation);
   }
   if (bEncountered > 0)
   {
    Bandit = Spawn(class'NineToes',S.Owner,S.Tag,S.Location + vect(0,0,10), S.Rotation);
    Bandit.TakeDamage(1, None, Vect(0,0,0), Bandit.Location, 'Shot');
   }
   Bandit.BindName = S.BindName;
   Bandit.Orders = S.Orders;
   Bandit.OrderTag = S.OrderTag;
   Bandit.Event = S.Event;
   Bandit.LevelStrength = int(CurrentLevel) + Rand(3) + (bEncountered * 3);
   if (Bandit.LevelStrength > 50 && bEncountered < 1) Bandit.LevelStrength = 50;
   Bandit.ApplyHealthLevel();
   Bandit.Alliance = S.Alliance;
   Bandit.ConBindEvents();
   Bandit.bInvincible = S.bInvincible;
   Bandit.bImportant = S.bImportant;
   
   //if (!S.bInWorld) Bandit.LeaveWorld();
   
   if (HasKey(S, Key)) Key.GiveTo(Bandit);
   
   if (!S.IsA('MJ12Commando'))
   {
    for(i=0; i<8; i++)
    {
     Bandit.InitialInventory[i] = S.InitialInventory[i];
     if (bEncountered < 1) Bandit.InitialAlliances[i] = S.InitialAlliances[i];
    }
   }

   if (S.IsA('Robot') || S.IsA('MJ12Commando'))
   {
    for(i=0; i<8; i++)
    {
     if (bEncountered < 1) Bandit.InitialInventory[i] = Class'MJ12Troop'.Default.InitialInventory[i];
     Bandit.InitialAlliances[i] = S.InitialAlliances[i];
    }
   }

   S.bImportant = False;  
   S.Event = '';
   S.Destroy();
  }




  if (S.IsA('ThugMale') || S.IsA('ThugMale2') || S.IsA('TriadLumPath') || S.IsA('TriadLumPath2') || S.IsA('TriadRedArrow'))
  {
   S.SetCollisionSize(0,0);
   S.SetCollision(False, False, False);
   Psycho = Spawn(class'Psycho',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);
   Psycho.BindName = S.BindName;
   Psycho.Orders = S.Orders;
   Psycho.OrderTag = S.OrderTag;
   Psycho.Event = S.Event;
   Psycho.LevelStrength = int(CurrentLevel) + Rand(3);
   if (Psycho.LevelStrength > 50) Psycho.LevelStrength = 50;
   Psycho.ApplyHealthLevel();
   Psycho.Alliance = S.Alliance;
   Psycho.ConBindEvents();
   Psycho.bInvincible = S.bInvincible;
   Psycho.bImportant = S.bImportant;

   //if (!S.bInWorld) Psycho.LeaveWorld();

   if (HasKey(S, Key)) Key.GiveTo(Psycho);
   
   for(i=0; i<8; i++)
   {
    Psycho.InitialAlliances[i] = S.InitialAlliances[i];
   }

   S.bImportant = False;    
   S.Event = '';
   S.Destroy();
  }





  if (S.IsA('ChildMale') || S.IsA('ChildMale2') || S.IsA('JunkieFemale') || S.IsA('SpiderBot2'))
  {
   S.SetCollisionSize(0,0);
   S.SetCollision(False, False, False);
   Midget = Spawn(class'MidgetPsycho',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);
   //Midget.BindName = S.BindName;
   Midget.Orders = S.Orders;
   Midget.OrderTag = S.OrderTag;
   Midget.Event = S.Event;
   Midget.LevelStrength = int(CurrentLevel) + Rand(3);
   if (Midget.LevelStrength > 50) Midget.LevelStrength = 50;
   Midget.ApplyHealthLevel();
   Midget.Alliance = 'Psycho';
   //Psycho.ConBindEvents();
   Midget.bInvincible = S.bInvincible;
   Midget.bImportant = S.bImportant;

   //if (!S.bInWorld) Psycho.LeaveWorld();

   if (HasKey(S, Key)) Key.GiveTo(Midget);
   
   /*for(i=0; i<8; i++)
   {
    Midget.InitialAlliances[i] = S.InitialAlliances[i];
   }*/
   
   Midget.InitialAlliances[0].AllianceName = 'Player';
   Midget.InitialAlliances[0].AllianceLevel = -1.0;
   Midget.InitialAlliances[0].bPermanent = True;
   Midget.InitialAlliances[1].AllianceName = 'Psycho'; //they tend to fight each other for some reason...
   Midget.InitialAlliances[1].AllianceLevel = 1.0;
   Midget.InitialAlliances[1].bPermanent = True;

   S.bImportant = False;    
   S.Event = '';
   S.Destroy();
  }





  if (( S.IsA('SecurityBot2') && FirstLevelInfo().MissionNumber > 3) || S.IsA('SecurityBot3') || S.IsA('ThugMale3') || S.IsA('SecurityBot4'))
  {
   S.SetCollisionSize(0,0);
   S.SetCollision(False, False, False);
   if (Frand() < 0.9) Bruiser = Spawn(class'Bruiser',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);
   if (Bruiser == None) Bruiser = Spawn(class'BadassBruiser',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);
   Bruiser.BindName = S.BindName;
   Bruiser.Orders = S.Orders;
   Bruiser.OrderTag = S.OrderTag;
   Bruiser.Event = S.Event;
   Bruiser.LevelStrength = int(CurrentLevel) + Rand(3);
   if (Bruiser.LevelStrength > 50) Bruiser.LevelStrength = 50;
   Bruiser.ApplyHealthLevel();
   Bruiser.Alliance = S.Alliance;
   Bruiser.ConBindEvents();
   Bruiser.bInvincible = S.bInvincible;
   Bruiser.bImportant = S.bImportant;

   if (HasKey(S, Key)) Key.GiveTo(Bruiser);

   //if (!S.bInWorld) Bruiser.LeaveWorld();
   
   if (!S.IsA('Robot') && !S.IsA('MJ12Commando'))
   {
    for(i=0; i<8; i++)
    {
     if (bEncountered < 1) Bruiser.InitialInventory[i] = S.InitialInventory[i];
     Bruiser.InitialAlliances[i] = S.InitialAlliances[i];
    }
   }
   if (S.IsA('Robot') || S.IsA('MJ12Commando'))
   {
    for(i=0; i<8; i++)
    {
     if (bEncountered < 1) Bruiser.InitialInventory[i] = Class'MJ12Troop'.Default.InitialInventory[i];
     Bruiser.InitialAlliances[i] = S.InitialAlliances[i];
    }
   }

   S.bImportant = False;    
   S.Event = '';
   S.Destroy();
  }




  if (S.IsA('MilitaryBot') || (S.IsA('MIB') || S.IsA('WIB') || ( S.IsA('SpiderBot') && !S.IsA('SpiderBot2')) && S.bInWorld && (FirstLevelInfo().MissionNumber != 4 || FirstPlayer().FlagBase.GetBool('TalkedToPaulAfterMessage_Played') )))
  {
   S.SetCollisionSize(0,0);
   S.SetCollision(False, False, False);

   RandomEncounter('Bruiser', bEncountered);

   if (bEncountered < 1)
   {
    Bruiser = Spawn(class'BadassBruiser',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);
   }
   if (bEncountered > 0)
   {
    Bruiser = Spawn(class'Sledge',S.Owner,S.Tag,S.Location + vect(0,0,10) + Comp, S.Rotation);    
    Bruiser.TakeDamage(1, None, Vect(0,0,0), Bruiser.Location, 'Shot');
   }
   Bruiser.BindName = S.BindName;
   Bruiser.Orders = S.Orders;
   Bruiser.OrderTag = S.OrderTag;
   Bruiser.Event = S.Event;
   Bruiser.LevelStrength = int(CurrentLevel) + Rand(3) + (bEncountered * 3);
   if (Bruiser.LevelStrength > 50 && bEncountered < 1) Bruiser.LevelStrength = 50;
   Bruiser.ApplyHealthLevel();
   Bruiser.Alliance = S.Alliance;
   Bruiser.ConBindEvents();
   Bruiser.bInvincible = S.bInvincible;
   Bruiser.bImportant = S.bImportant;

   //if (!S.bInWorld) Bruiser.LeaveWorld();

   if (HasKey(S, Key)) Key.GiveTo(Bruiser);
   
   if (!S.IsA('Robot') && bEncountered < 1)
   {
    for(i=0; i<8; i++)
    {
     Bruiser.InitialInventory[i] = S.InitialInventory[i];
     Bruiser.InitialAlliances[i] = S.InitialAlliances[i];
    }
   }
   if (S.IsA('Robot'))
   {
    for(i=0; i<8; i++)
    {
     Bruiser.InitialInventory[i] = Class'MJ12Troop'.Default.InitialInventory[i];
     if (bEncountered < 1) Bruiser.InitialAlliances[i] = S.InitialAlliances[i];
    }
   }

   S.bImportant = False;    
   S.Event = '';
   S.Destroy();
  }
  }






 }
}

function bool HasKey(Pawn B, out Nanokey K)
{
 local Nanokey TK;
 
 forEach AllActors(class'Nanokey', TK)
 {
  if (TK != None && (TK.Owner == B || TK.Base == B))
  {
   K = TK;
   Return True;
  }
 }
 
 return False;
}

function PawnDeath(Pawn A, Pawn B, name Type)
{
 local Nanokey K;
 
 if (String(B) ~= Target) HideTargetWindow();
 
 if (!B.IsA('BorderlandsPawn') && !B.IsA('BorderlandsAnimal')) return;

 if (LastKill == B) return;
 
 LastKill = B;
 
 if (HasKey(B, K)) DropKey(K);
 
 if (frand() < float(ItemChance) / 100 && !B.IsA('DeusExPlayer'))
 {
  DropRandomItem(B);
 }
 if (frand() < float(ItemChance) / 100 && !B.IsA('DeusExPlayer'))
 {
  DropRandomItem(B);
 }
 if (frand() < float(ItemChance) / 100 && !B.IsA('DeusExPlayer'))
 {
  DropRandomItem(B);
 }
 if (BorderlandsPawn(B).DropItem != None)
 {
  DropSpecialItem(B, BorderlandsPawn(B).DropItem);
 }
 
 if (A == FirstPlayer() && CurrentLevel != "50") CurXP = string( (int(CurXP) + GetXPFrom(BorderlandsPawn(B).MaxHealthMark, BorderlandsPawn(B).LevelStrength)) );
 
 if (int(CurXP) > int(XPNeeded)) LevelUp();
}

function LevelUp()
{
 local int Level;
 
 Mutator.ShowMessage(FirstPlayer(), "|ca128f0You Are Now Level |p4"$string( int(CurrentLevel) + 1 )  );
 FirstPlayer().PlaySound(Sound'Menu_BuySkills');
 FirstPlayer().HealPlayer(600, False);
 
 CurXP = "0";
 
 Level = int(CurrentLevel);
 
 XPNeeded = String( int(  int(XPNeeded) + 500 * (float(CurrentLevel) / 5) )  );
 
 CurrentLevel = String(Level + 1);
 
 if (CurrentLevel ~= "50")
 {
  XPNeeded = "";
  XPNeeded = "";
 }
 
 SpawnFireworks(FirstPlayer(), Level + 1);
 SpawnFireworks2(FirstPlayer(), Level + 1);
 SpawnFireworks3(FirstPlayer(), Level + 1);
 SpawnFireworks(FirstPlayer(), Level + 1);
 SpawnFireworks2(FirstPlayer(), Level + 1);
 SpawnFireworks3(FirstPlayer(), Level + 1);
 SpawnFireworks(FirstPlayer(), Level + 1);
 SpawnFireworks2(FirstPlayer(), Level + 1);
 SpawnFireworks3(FirstPlayer(), Level + 1);
 SpawnFireworks(FirstPlayer(), Level + 1);
 SpawnFireworks2(FirstPlayer(), Level + 1);
 SpawnFireworks3(FirstPlayer(), Level + 1);
 SpawnFireworks(FirstPlayer(), Level + 1);
 SpawnFireworks2(FirstPlayer(), Level + 1);
 SpawnFireworks3(FirstPlayer(), Level + 1);
}

function SpawnFireworks(Actor A, int NewLevel)
{
 local String S, CurS, Color;
 local int i, j, k, l, Length;
 
 S = String(NewLevel);
 
 if (NewLevel > 9999) NewLevel = 9999;
 
 Length = Len(S);
 
 if (Length == 1)
 {
  i = NewLevel;
 }
 if (Length == 2)
 {
  j = int( LeftTrim(S, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 3)
 {
  k = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 4)
 {
  l = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 2, 1) );
  k = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 
 Color = "Purple";
 
 SpawnNumbers(i, j, k, l, Color, Len(S), A);
}
function SpawnFireworks2(Actor A, int NewLevel)
{
 local String S, CurS, Color;
 local int i, j, k, l, Length;
 
 S = String(NewLevel);
 
 if (NewLevel > 9999) NewLevel = 9999;
 
 Length = Len(S);
 
 if (Length == 1)
 {
  i = NewLevel;
 }
 if (Length == 2)
 {
  j = int( LeftTrim(S, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 3)
 {
  k = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 4)
 {
  l = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 2, 1) );
  k = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 
 Color = "Green";
 
 SpawnNumbers(i, j, k, l, Color, Len(S), A);
}
function SpawnFireworks3(Actor A, int NewLevel)
{
 local String S, CurS, Color;
 local int i, j, k, l, Length;
 
 S = String(NewLevel);
 
 if (NewLevel > 9999) NewLevel = 9999;
 
 Length = Len(S);
 
 if (Length == 1)
 {
  i = NewLevel;
 }
 if (Length == 2)
 {
  j = int( LeftTrim(S, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 3)
 {
  k = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 4)
 {
  l = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 2, 1) );
  k = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 
 Color = "Blue";
 
 SpawnNumbers(i, j, k, l, Color, Len(S), A);
}


function SpawnNumbers(int i, int j, int k, int l, string Color, int Length, Actor A)
{
 local BLNumberSpriteLong N;
 local Vector V, O;
 
 //BroadcastMessage(Length);
 
 if (i == 0) i = 1;
 
 V = (vect(0,0,1) * A.CollisionHeight * 1.2) + ((vect(0,1,0) >> A.Rotation) * Rand(10)) + (vect(0,0,1) * Rand(10));
 
 O = vect(0,4,0) >> A.Rotation;
 
 N = Spawn(class'BLNumberSpriteLong', A,,A.Location + V + O);
 N.Color = Color;
 N.Number = i;
 N.UpdateTexture();
 
 if (Length > 1)
 {
  N = Spawn(class'BLNumberSpriteLong', A,,A.Location + V + (O * 2));
  N.Color = Color;
  N.Number = j;
  N.UpdateTexture();
 }
 
 if (Length > 2)
 {
  N = Spawn(class'BLNumberSpriteLong', A,,A.Location + V + (O * 3));
  N.Color = Color;
  N.Number = k;
  N.UpdateTexture();
 }
 
 if (Length > 3)
 {
  N = Spawn(class'BLNumberSpriteLong', A,,A.Location + V + (O * 4));
  N.Color = Color;
  N.Number = l;
  N.UpdateTexture();
 }
}

function int GetXPFrom(int H, int Level)
{
 local float F, M;
 
 M = Level / float(CurrentLevel);
 
 f = float(H) * M;
 
 if (F < 1) f = 1;
 
 return int(f);
}

function DropRandomItem(Pawn B)
{
 local int r;
 local class<Inventory> SpawnType;
 local Inventory A;
 
 R = rand(100);
 
 if (r >= 0 && r < 15)
 {
  SpawnType = class'InstaHealVial';
 }
 if (r >= 15 && r < 20)
 {
  SpawnType = class'HealVial';
 }
 if (r >= 20 && r < 30)
 {
  SpawnType = class'AmmoSMG';
 }
 if (r >= 30 && r < 40)
 {
  SpawnType = class'AmmoPistol';
 }
 if (r >= 40 && r < 50)
 {
  SpawnType = class'AmmoShotgun';
 }
 if (r >= 50 && r < 60)
 {
  SpawnType = class'AmmoSniper';
 }
 if (r >= 60 && r < 70)
 {
  SpawnType = class'AmmoCombatRifle';
 }
 if (r >= 70 && r < 80)
 {
  SpawnType = class'AmmoLauncher';
 }
 if (r >= 80 && r < 90)
 {
  SpawnType = class'AmmoRevolver';
 }
 if (r >= 90 && r < 95)
 {
  SpawnType = RandomGunType();
 }
 if (r >= 95)
 {
  SpawnType = class'RandomMoneys';
 }
 
 A = spawn(SpawnType,,,B.Location);
 
 FlingItem(A, 15 + Rand(6), B.Location, int(CurrentLevel));
}


function DropSpecialItem(Pawn B, class<Inventory> Item)
{
 local Inventory A;
 
 A = spawn(Item,,,B.Location);
 
 if (A.IsA('SledgesShotgun'))
 {
  SledgesShotgun(A).WeaponLevel = int(CurrentLevel);
  SledgesShotgun(A).RandomizeStats();
 }
 if (A.IsA('Clipper'))
 {
  Clipper(A).WeaponLevel = int(CurrentLevel);
  Clipper(A).RandomizeStats();
 }
 
 FlingItem(A, 15 + Rand(6), B.Location, int(CurrentLevel));
}

function class<Weapon> RandomGunType()
{
 local int r;
 
 r = rand(7);
 
 if (r == 0) return class'RandomShotgun';
 if (r == 1) return class'RandomSniper';
 if (r == 2) return class'RandomRepeater';
 if (r == 3) return class'RandomRevolver';
 if (r == 4) return class'RandomCobra';
 if (r == 5) return class'RandomMachineGun';
 if (r == 6) return class'RandomSMG';
}

function DropKey(Nanokey item)
{
	local vector dir;
	local Nanokey A;

//	dir = vrand();
//	dir.Z += 1;
//	dir = dir >> rotation;

	/*if(!item.SetLocation(loc))
	{
	    item.Destroy();
	    return;
	}*/
        
	A = Spawn(class'Nanokey',,,LastKill.Location);
	A.KeyID = item.KeyID;
	A.Description = item.Description;
	A.DrawScale = 2.5;
	A.PickupViewScale = 2.5;
	A.SetCollisionSize(A.CollisionRadius * 2.5, A.CollisionHeight * 2.5);
	
	/*item.SetPhysics(PHYS_Falling);
	item.RemoteRole = ROLE_DumbProxy;
	item.NetPriority = 2.5;
	item.BecomePickup();
	item.bCollideWorld = true;
	item.GotoState('PickUp', 'Dropped');*/
}

static function FlingItem(inventory item, float str, vector loc, int TempLevel)
{
	local vector dir;

	dir = vrand();
	dir.Z += 1;
//	dir = dir >> rotation;

	if(!item.SetLocation(loc))
	{
	    item.Destroy();
	    return;
	}
	item.SetPhysics(PHYS_Falling);
	item.RemoteRole = ROLE_DumbProxy;
	item.NetPriority = 2.5;
	item.BecomePickup();
	item.bCollideWorld = true;
	item.GotoState('PickUp', 'Dropped');
	item.Velocity = dir * str * 2 * (1 + frand());
	item.bFixedRotationDir = True;
	item.RotationRate = rotrand(true);
	
	 if (Item.IsA('RandomShotgun'))
	 {
	  RandomShotgun(Item).WeaponLevel = TempLevel;
	  RandomShotgun(Item).RandomizeStats();
	 }
	 if (Item.IsA('RandomSniper'))
	 {
	  RandomSniper(Item).WeaponLevel = TempLevel;
	  RandomSniper(Item).RandomizeStats();
	 }
	 if (Item.IsA('RandomRepeater'))
	 {
	  RandomRepeater(Item).WeaponLevel = TempLevel;
	  RandomRepeater(Item).RandomizeStats();
	 }
	 if (Item.IsA('RandomRevolver'))
	 {
	  RandomRevolver(Item).WeaponLevel = TempLevel;
	  RandomRevolver(Item).RandomizeStats();
	 }
	 if (Item.IsA('RandomCobra'))
	 {
	  RandomCobra(Item).WeaponLevel = TempLevel;
	  RandomCobra(Item).RandomizeStats();
	 }
	 if (Item.IsA('RandomMachineGun'))
	 {
	  RandomMachineGun(Item).WeaponLevel = TempLevel;
	  RandomMachineGun(Item).RandomizeStats();
	 }
	 if (Item.IsA('RandomSMG'))
	 {
	  RandomSMG(Item).WeaponLevel = TempLevel;
	  RandomSMG(Item).RandomizeStats();
	 }
}

function ClearCorpses()
{
 local Carcass C;
 
 forEach AllActors(class'Carcass', C)
 {
  if (C.CollisionRadius > 0)
  {
   C.SetCollisionSize(0, C.CollisionHeight);
   C.SetPropertyText("Lifespan", "20");
  }
 }
}

function DeusExLevelInfo FirstLevel()
{
 local DeusExLevelInfo L;
 
 forEach AllActors(class'DeusExLevelInfo', L)
 {
  return L;
 }
}

defaultproperties
{
     ItemChance=60
     InvSlotsX=0
     InvSlotsY=0
     ItemArticle=""
     ItemName="MSBorderlands Mutator Active."
     PickupMessage=""
     CollisionHeight=0
     CollisionRadius=0
     CurXP="0"
     XPNeeded="200"
}
